//=============================================================================
//  Microsoft (R) Network Monitor (tm). 
//  Copyright (C) 1997-1999. All rights reserved.
//
//  MODULE: NMEvent.h
//
//  The basis of all Network Monitor Events
//=============================================================================

#ifndef _NMEVENT_H_
#pragma option push -b -a8 -pc -A- /*P_O_Push*/
#define _NMEVENT_H_

// we only need this include to get MAC_ADDRESS_SIZE and IPX_ADDRESS
#include <npptypes.h>

// we say zero length arrays are just fine...
#pragma warning(disable:4200)

// NMCOLUMNTYPE
typedef enum 
{

    NMCOLUMNTYPE_UINT8 = 0,
    NMCOLUMNTYPE_SINT8,
    NMCOLUMNTYPE_UINT16,
    NMCOLUMNTYPE_SINT16,
    NMCOLUMNTYPE_UINT32,
    NMCOLUMNTYPE_SINT32,
    NMCOLUMNTYPE_FLOAT64,
    NMCOLUMNTYPE_FRAME,
    NMCOLUMNTYPE_YESNO,
    NMCOLUMNTYPE_ONOFF,
    NMCOLUMNTYPE_TRUEFALSE,
    NMCOLUMNTYPE_MACADDR,
    NMCOLUMNTYPE_IPXADDR,
    NMCOLUMNTYPE_IPADDR,
    NMCOLUMNTYPE_VARTIME,
    NMCOLUMNTYPE_STRING

} NMCOLUMNTYPE;

// NMCOLUMNVARIANT
typedef struct _NMCOLUMNVARIANT
{
    NMCOLUMNTYPE Type;
    union
    {
       BYTE     Uint8Val;    // 8 bit unsigned value
       char     Sint8Val;    // 8 bit signed value
       WORD     Uint16Val;   // 16 bit unsigned value
       short    Sint16Val;   // 16 bit signed value
       DWORD    Uint32Val;   // 32 bit unsigned value
       long     Sint32Val;   // 32 bit signed value
       DOUBLE   Float64Val;  // 64 bit floating point value
       DWORD    FrameVal;    // 32 bit unsigned frame value
       BOOL     YesNoVal;    // 32 bit boolean: zero maps to 'NO', nonzero maps to 'YES'
       BOOL     OnOffVal;    // 32 bit boolean: zero maps to 'OFF', nonzero maps to 'ON'
       BOOL     TrueFalseVal;// 32 bit boolean: zero maps to 'False', nonzero maps to 'True'
       BYTE     MACAddrVal[MAC_ADDRESS_SIZE];// 48 bit MAC address (6 bytes)
       IPX_ADDRESS IPXAddrVal;// 10 byte ipx address (4 byte subnet. 6 byte address)
       DWORD    IPAddrVal;   // 32 bit IP Address: ddd.ddd.ddd.ddd
       DOUBLE   VarTimeVal;  // Double representation of time value (use VariantTimeToSystemTime to convert)
       LPCSTR  pStringVal;   // pointer to a string value
    } Value;
} NMCOLUMNVARIANT;

// COLUMNINFO
typedef struct _NMCOLUMNINFO
{
    LPSTR           szColumnName;// Name of column
    NMCOLUMNVARIANT VariantData; // Value for column
} NMCOLUMNINFO;                                                  
typedef NMCOLUMNINFO* PNMCOLUMNINFO;                                         
             
// JTYPE
typedef LPSTR JTYPE; // (structure placeholder)

// EVENTDATA
typedef struct _NMEVENTDATA
{                                                                   
    LPSTR      pszReserved;  // Reserved
    BYTE       Version;      // Version for this structure (must be 0)
    DWORD      EventIdent;   // ID for this event
    DWORD      Flags;        // Flags for Expert generated or Monitor generated and others
    DWORD      Severity;     // Severity level
    BYTE       NumColumns;   // Number of optional columns for this event
    LPSTR      szSourceName; // Name of Monitor or Expert
    LPSTR      szEventName;  // Name of event
    LPSTR      szDescription;// Description of event
    LPSTR      szMachine;    // Name (or IPADDRESS?) of the machine supplying the event (NULL for Experts usually)
    JTYPE      Justification;// Justification pane info (currently a string, but possible structure)
    LPSTR      szUrl;        // URL to Book of Knowledge  (NULL for default for ID?)
    SYSTEMTIME SysTime;      // Systemtime of the event
    NMCOLUMNINFO Column[0];    // Array of optional columns with their names and data
} NMEVENTDATA;
typedef NMEVENTDATA* PNMEVENTDATA;

// EVENT FLAGS
#define NMEVENTFLAG_MONITOR                      0x00000000   // Event was generated by a monitor
#define NMEVENTFLAG_EXPERT                       0x00000001   // Event was generated by an expert

#define NMEVENTFLAG_DO_NOT_DISPLAY_SEVERITY      0x80000000
#define NMEVENTFLAG_DO_NOT_DISPLAY_SOURCE        0x40000000
#define NMEVENTFLAG_DO_NOT_DISPLAY_EVENT_NAME    0x20000000
#define NMEVENTFLAG_DO_NOT_DISPLAY_DESCRIPTION   0x10000000
#define NMEVENTFLAG_DO_NOT_DISPLAY_MACHINE       0x08000000
#define NMEVENTFLAG_DO_NOT_DISPLAY_TIME          0x04000000
#define NMEVENTFLAG_DO_NOT_DISPLAY_DATE          0x02000000

//#define NMEVENTFLAG_DO_NOT_DISPLAY_FIXED_COLUMNS (NMEVENTFLAG_DO_NOT_DISPLAY_SEVERITY   | \
//                                                  NMEVENTFLAG_DO_NOT_DISPLAY_SOURCE     | \
//                                                  NMEVENTFLAG_DO_NOT_DISPLAY_EVENT_NAME | \
//                                                  NMEVENTFLAG_DO_NOT_DISPLAY_DESCRIPTION| \
//                                                  NMEVENTFLAG_DO_NOT_DISPLAY_MACHINE    | \
//                                                  NMEVENTFLAG_DO_NOT_DISPLAY_TIME       | \
//                                                  NMEVENTFLAG_DO_NOT_DISPLAY_DATE )
#define NMEVENTFLAG_DO_NOT_DISPLAY_FIXED_COLUMNS 0xFE000000


enum  _NMEVENT_SEVERITIES
{
    NMEVENT_SEVERITY_INFORMATIONAL = 0,
    NMEVENT_SEVERITY_WARNING,
    NMEVENT_SEVERITY_STRONG_WARNING,
    NMEVENT_SEVERITY_ERROR,
    NMEVENT_SEVERITY_SEVERE_ERROR,
    NMEVENT_SEVERITY_CRITICAL_ERROR 
};


// turn this warning back on
#pragma warning(default:4200)


#pragma option pop /*P_O_Pop*/
#endif // _EVENT_H_
